function [mission, mission_next] = smoothCycle(mission, mission_next, vehModel, veh)
% vehAcc: current acceleration
% vehSpd: current speed
% vehSpd_next: speed at the next timestep

vehSpd = mission.vehSpd;
vehSpd_next = mission_next.vehSpd;

vehAcc = ( vehSpd_next - vehSpd ) / veh.dt;

% VECTO behavioral acc. limits
accLimitUp = griddedInterpolant([0 25 60 120]/3.6, [1, 1, 0.5, 0.5]);
accLimitLo = griddedInterpolant([0 50 60 120]/3.6, -[1, 1, 0.5, 0.5]);

accLimitUp = accLimitUp(vehSpd);
accLimitLo = accLimitLo(vehSpd);

if vehAcc > accLimitUp
    vehAcc = accLimitUp;
    vehSpd_next = vehSpd + vehAcc .* veh.dt;
elseif vehAcc < accLimitLo
    vehAcc = accLimitLo;
    vehSpd_next = vehSpd + vehAcc .* veh.dt;
end

mission.vehAcc = vehAcc;

% Physical limits
% Limits based on components' torque/power
[~, unfeas] = vehModel(mission);

if unfeas
    if vehAcc >= 0
        % Try smaller accelerations
        vehAccGrid = -1:0.01:vehAcc; % m/s^2
    else
        % Try smaller decelerations
        vehAccGrid = 0:-0.01:vehAcc; % m/s^2
    end

    mission.vehAcc = vehAccGrid;
    [~, unfeas] = vehModel(mission);

    % Index of the strongest acceleration/deceleration that is feasible
    maxAccIdx = find(unfeas == 0, 1, 'last');

     % Handle caes with no feasibile acceleration
    if isempty(maxAccIdx)
        maxAccIdx = 1;
    end

    % Keep the strongest acceleration/deceleration that is feasible and
    % re-evaluate vehSpd_next
    vehAcc = vehAccGrid(maxAccIdx);
    vehSpd_next = vehSpd + vehAccGrid(maxAccIdx) .* veh.dt;
end

% Limits based on engine and e-machines speed limits
if vehSpd_next > veh.maxSpd
    vehSpd_next = veh.maxSpd;
    vehAcc = ( vehSpd_next - vehSpd ) / veh.dt;
end

mission.vehAcc = vehAcc;
mission_next.vehSpd = vehSpd_next;

end


